subroutine Ast(Parameter_ein,Lang,Radien,Temperaturen,Zeiten)
	use Funktionen
	use Naturkonstanten
	use Modelleinstellungen
	use Parameter
	use omp_lib
	implicit none
	integer,intent(out) :: Lang
	real(kind=8), dimension(:),intent(out), allocatable :: Radien,Zeiten
	real(kind=8), dimension(:,:),intent(out), allocatable :: Temperaturen 
	real(kind=8), dimension(ParZahl),intent(in) :: Parameter_ein
	real(kind=8), dimension(:,:),allocatable :: Temperaturen1
	real(kind=8), dimension(:), allocatable :: Zeiten1
	real(kind=8),dimension(:), allocatable :: R,r_v,rz_v,rz,T,T_v,rho,D,D_v,Dv,P,M,Q,rho_p,Tp
	real(kind=8),dimension(:), allocatable :: delT,delD,Tpv,Tiefe,P_G,Dp,T_vv,D_vv,T_maxi,D_eff
	real(kind=8) :: Zeit,dt,dt_max
	real(kind=8) :: Ri,h	
	integer :: i,j,n, iteration, it_zahl
	logical :: it_signal
	integer, dimension(:), allocatable :: j_alt
	real(kind=8),dimension(3) :: xwert,ywert	
	real(kind=8),dimension(MetZahl) :: PosFak,T_max1
	real(kind=8) :: Tiefenwert
	real(kind=8),dimension(0:k) :: Kornradius
	integer,dimension(MetZahl) :: Tiefe1
	integer :: k_aktuell,k_aktuell_v
	real(kind=8),dimension(:),allocatable :: M_Vorgabe,M_v
	real(kind=8) :: M_Anfang
	integer,parameter :: Lang_max = 10000
	
	allocate(R(0:k))
	allocate(R_v(0:k))
	allocate(T(0:k))
	allocate(D(0:k))
	allocate(Dp(0:k))
	allocate(D_v(0:k))
	allocate(P(0:k))
	allocate(Tp(0:k))
	allocate(M(0:k))
	allocate(Q(0:k))
	allocate(rho(0:k))
	allocate(rho_p(0:k))
	allocate(delT(0:k))
	allocate(delD(0:k))
	allocate(T_v(0:k))
	allocate(Tpv(0:k))
	allocate(Dv(0:k))
	allocate(Tiefe(0:k))
	allocate(P_G(0:k))
	allocate(rz_v(0:k))
	allocate(rz(0:k))
	allocate(j_alt(0:k))
	allocate(T_vv(0:k))
	allocate(D_vv(0:k))
	allocate(D_eff(0:k))
	allocate(T_maxi(0:k))	
	allocate(M_Vorgabe(0:k))
	allocate(M_v(0:k))	
	allocate(Radien(0:k))
	allocate(Zeiten1(Lang_max))
	allocate(Temperaturen1(0:k,Lang_max))
	allocate(D_schliessen(0:k))
	allocate(MaskeT(0:k))

	!Initialisations
	R		= 0.d0
	R_v	= 0.d0;	T_v=1.d0;	D_v=1.d0
	D_schliessen = .false.
	T__max	= 0
	j_alt 	= 0
	Lang 	= 0	
	P		= 0.d0
	T_maxi 	= 0.d0
	n		= 0
	MaskeT 	= .false.
  T_max1 = 0.d0

	Bildungszeit= Parameter_ein(1) *1.d6		!Formation time now in years
	Radius      = Parameter_ein(2) *1.d3				!Asteroid Radius now in meters
	f_Fe60      = Parameter_ein(3) *1.d-6			!Fe60/Fe56-ratio now in fraction of one
	phi_0       = Parameter_ein(4)					!Porosity in fraction of one
	T_0         = Parameter_ein(5)						!Initial and surface temperature after disk dispersal in Kelvin
	Wlvf        = Parameter_ein(6)						!Bulk heat conductivity in W/mK
	Akkretionsdauer = Parameter_ein(7)*1.d6		!Length of linear Accretion now in years
	T_S         = Parameter_ein(8)						!Initial and surface temperature before disk dispersal											

	
	!Initialising spacial grid of mass and Radius
	r = 0.d0;	M = 0.d0
	
	!Calculation of radius shells
	!Ri is the radius of the first shell in the center which is not zero. 
	!By reducing of Ri the spacial resolution at the surface can be increased at the expense of the 
	!spacial resolution in the center.
	Ri = .5d3
	h = dble(k)**(-1)*log10(Radius/Ri)
	do i = 0,k		
		Tiefe(i) = Ri * 10.d0**(h*i)			
	end do
	R(0) = 0.d0
	do i = 1,k
		!Here you can decide if you wish to have equidistant or logarithmic spacial resolution by 
		!commenting out the other one
		R(i) = Radius+Ri-Tiefe(k-i)   	!logarithmic
		!R(i) = dble(i)* Radius/dble(k)	!equidistant
	end do

	!Placing a given meteorite depth within the appropriate mass shell (H chondrite)
	if (Programmtyp == 'Durchlauf') then
		do i = 1,k
			do j = 1,MetZahl
				if (R(i) >= Radius-TieH(j) .and. R(i-1) < Radius-TieH(j)) then
					Tiefe1(j) = i
					PosFak(j)=((Radius-TieH(j))-R(i-1))/(R(i)-R(i-1)) !y=(r_abs-r_(i-1))/(r_i-r_(i-1))
				end if
			end do
		end do
	end if

	!more data file stuff
	if (Programmtyp == 'Evolution') then	
		do i = 0,k			
			Radien(i) = R(i)/1.d3
		end do
	end if		
	
	T= T_S			  !Initial temperature is disk temperature
	D= 1.d0-phi_0	!Filling density D is used in calculations to simulate porosity effects due to mathematical practicability
	
	!Defining mixture type
	!If Gemisch = .true. then a mixture of chondrules and matrix is calculated which can 
	!either be matrix dominated or chondrule dominated
	!If Gemisch = .false. then only a single component material is assumed with grain radius 
	!"Kornradius"
	if (Gemisch .eqv. .true.) then		
		if (matrixdominiert 	.eqv. .true.) Kornradius = Korn_M
		if (chondrendominiert 	.eqv. .true.) Kornradius = Korn_C
		if (chondrendominiert 	.eqv. .true.) D = D_cp / (1.d0-f_ma)
		if (matrixdominiert 	.eqv. .true.) D = D_cp
	else
		Kornradius = Korn_H
	end if

	P=Aussendruck		!Pressure is set to athospheric/disk pressure at surface of asteroid	
	Zeit = Bildungszeit	!The time (Zeit) starts when the asteroid starts to exist at formation time (Bildungszeit)

	!Get masses of radius shells
	M_Vorgabe=0.d0
	do i =0,k-1
		M_Vorgabe(i+1) = M_Vorgabe(i) + vpid*rho_0*(r(i+1)**3-r(i)**3)	
	end do

	!Growth is only enabled if Akkretionsdauer > Wachstumsgrenze (see mainfile).
	!In case of growth body is filled with mass only within initial radius.
	if (Akkretionsdauer <= Wachstumsgrenze) then
		!If growth is not considered
		M = M_Vorgabe
		k_aktuell = k
		MaskeT = .true.
		MaskeT(k_aktuell) = .false.
		Wachstumsstop = .false.
	else
		!If growth is considered
		MaskeT = .false.
		i = 0
		!checking shell number of initial body
		do while (r(i) <= Radius_Anfang)
			M(i) = M_Vorgabe(i)
			i = i+1
		end do
		M(i) = M(i-1)+ vpid*rho_0*(Radius_Anfang**3-r(i-1)**3) !Radius_Anfang: given radius of initial body
		k_aktuell = i
		
		!zero mass for shells outside of initial body
		do i = k_aktuell+1,k
			M(i) = 0.d0
		end do
		M_Anfang = M(k_aktuell)	
		Wachstumsstop = .false. 
	
		!Only use mass shells within the body indicated by MaskeT for thermal evolution
		do i=0,k_aktuell-1
			MaskeT(i) = .true.
		end do
	end if

	!Opening output data files
	if (Programmtyp == 'Durchlauf') then			
		!Central temperature in the center and meteorite depths during thermal evolution	
		open(3, file = 'Ausgabe/Temperature.dat', status = 'replace')
		write(3,'(A72)') "#Temperature evolution in the centre as well as in the selected layers."
		write(3,122) " #   Time[Ma]", "centre","layer 1","layer 2","layer 3","layer 4",&
				  &"layer 5","layer 6","layer 7","layer 8","layer 9"
			
		open(4, file = 'Ausgabe/Filling_Density.dat', status = 'replace')	!Same for filling density
		write(4,'(A76)') "#Filling density evolution in the centre as well as in the selected layers."
		write(4,122) " #   Time[Ma]", "centre","layer 1","layer 2","layer 3","layer 4",&
				  &"layer 5","layer 6","layer 7","layer 8","layer 9"
			
		open(5, file = 'Ausgabe/Pressure.dat', status = 'replace')			!Same for pressure
		write(5,'(A69)') "#Pressure evolution in the centre as well as in the selected layers."
		write(5,122) " #   Time[Ma]", "centre","layer 1","layer 2","layer 3","layer 4",&
				  &"layer 5","layer 6","layer 7","layer 8","layer 9"		
		122	Format (A13,3x,A8,4x,9(A7,4x))
		
		!Output for a table which can be integrated in thermal evolution plots showing the surface 
		!temperature as a horizontal line during the entire thermal evolution
		open(98, file = 'Ausgabe/Initial_temperature.dat', status = 'replace')
		write(98,*) "#This file contains data points used to plot the surface temperature in thermal evolution plots."
		write(98,*) "#Model time[Ma],            surface temperature[K]"
		write(98,*) -5.d0,	T_0
		write(98,*) 1.d0,	T_0
		write(98,*) 200.d0, T_0
		close(98)
	end if

	!The once and only application of coldpressing for the case of initial porosities of more than 37%
	P = Kaltpressen(D,M,rho_p,r,P_G,T,k_aktuell)
	
	dt = 10.d0 		!Initial timestep size
	it_zahl = 10 	!Maximum allowed number of fixed point iterations of main equations before time step reduction	
	
	!Begin of main loop of solving heat conduction equation
	do while (Zeit < Dauer+Bildungszeit)		!Checking if end of thermal evolution is not reached yet
		Lang = Lang + 1
		!Increasing time step if change in temperature and filling density low enough
		if (maxval(abs(T-T_v)/(T_v +1.d-15),MaskeT) < 0.0015d0 .and. maxval(abs(D_v-D)/D) < 0.001d0) dt = dt*1.4d0	
		if ( Zeit < 25.d6 ) then 
			!Smaller allowed maximum time steps in early thermal evolution when there is much activity
			dt_max = 1.d4
		else
			dt_max = 1.d5
		end if
		if (dt > dt_max) dt = dt_max

		n=n+1
		
		!Store some initial variables for later use **
		T_vv = T_v;	D_vv = D_v
		T_v = T;		D_v = D
		R_v = R;		rz_v = rz
		Tp = T;			Dp = D
		k_aktuell_v = k_aktuell
		M_v = M					!For Growth	
	 	rz = r 					!For potential energy
		Q=Q_func(Zeit+dt)

		delT= 1.d0
		delD= 1.d0
	
		!Iteration	
		iteration = 0
		it_signal = .false.

		!Growth ("Wachstum")
		if ( k_aktuell <= k .and. Akkretionsdauer > Wachstumsgrenze ) &
			&M = Wachstum(k_aktuell,M,M_Vorgabe,dt,M_Anfang,Tp)
			
		!Calling subroutine for fixed point iteration
		call Fixpunktiteration		

		!If temperature change, filling density change or growth too strong or fixed point iteration 
		!takes too long, repeat time step with reduced timestep length
		do while ( maxval(abs(T-T_v)/(T_v +1.d-15),MaskeT) > 0.003d0 .or. maxval(abs(D_v-D)/D) > 0.003d0 &
			&.or. (it_signal .eqv. .true.) .or. (Wachstumsstop .eqv. .true.))
			dt=dt/1.5d0
			
			!Restore the stored variables **
			T = T_v;	D = D_v
	 		R = R_v;	rz = rz_v
	 		Tp = T;	Dp = D
	 		k_aktuell = k_aktuell_v
	 		M = M_v
			Q=Q_func(Zeit+dt)
			delT= 1.d0
			delD= 1.d0			

			!Iteration
			iteration = 0
			it_signal = .false.

			!Wachstum
			if ( k_aktuell <= k .and. M(k_aktuell) < M_Vorgabe(k) .and. Akkretionsdauer > Wachstumsgrenze) &
				&M = Wachstum(k_aktuell,M,M_Vorgabe,dt,M_Anfang,Tp)
				
			call Fixpunktiteration	
		end do

		!Save maximum temperature in each shell during thermal evolution for later output
		do i=0,k
	 		if (T(i) > T_maxi(i)) T_maxi(i) = T(i) 
	 	end do		

		!Calculation of temperature in layer of predefined meteorites. Important for genetical algorithm
		if (Programmtyp == 'Durchlauf') then
			do i = 1,MetZahl
				xwert(1) = R(Tiefe1(i)-1)
				xwert(2) = R(Tiefe1(i))
				xwert(3) = R(Tiefe1(i)+1)			
				ywert(1) = T(Tiefe1(i)-1)
				ywert(2) = T(Tiefe1(i))
				ywert(3) = T(Tiefe1(i)+1)
				Tiefenwert = R(Tiefe1(i)-1) + (R(Tiefe1(i))-R(Tiefe1(i)-1))*PosFak(i)	
				if (xwert(3) > 0.d0) then
		 			if (quadratischeInterpolation(xwert,ywert,Tiefenwert) > T_max1(i)) &
		 				&T_max1(i) = quadratischeInterpolation(xwert,ywert,Tiefenwert)  !T(Tiefe1-1)+(T(Tiefe1)-T(Tiefe1-1))*PosFak
				end if					
			end do
		end if	
				
		!Put new values in old variables
		T=Tp;	D=Dp	
	
		!console output: can be commented in if necessary	
		!write(*,'(A4,x,F7.3,x,A3,x,G12.4,x,F8.1,x,G13.5,x,I2)') "Zeit", Zeit/1.d6, "Mio", 1.d0-D_eff(0), T(0), dt
		
		!Thermal evolution output
		if (Programmtyp == 'Durchlauf') then
			write(*,'(F7.3,x,G11.4,2x,F8.1,11x,G12.5)') Zeit/1.d6, 1.d0-D_eff(0), T(0), dt
		
			write(3,'(F13.7,x,F10.4,x)',advance = 'no') Zeit/1.d6, T(0)
			write(4,'(F13.7,x,F10.4,x)',advance = 'no') Zeit/1.d6, D_eff(0)
			write(5,'(F13.7,x,F10.4,x)',advance = 'no') Zeit/1.d6, p(0)/1.d5
			do i=1,MetZahl-1 
				write(3,'(F10.4,x)',advance = 'no') T(Tiefe1(i)-1)+(T(Tiefe1(i))-T(Tiefe1(i)-1))*PosFak(i)
				write(4,'(F10.4,x)',advance = 'no') D_eff(Tiefe1(i))
				write(5,'(F10.4,x)',advance = 'no') p(Tiefe1(i))/1.d5
			end do
			write(3,'(F10.4,x)') T(Tiefe1(MetZahl)-1)+(T(Tiefe1(MetZahl))-T(Tiefe1(MetZahl)-1))*PosFak(MetZahl)
			write(4,'(F10.4,x)') D_eff(Tiefe1(MetZahl))
			write(5,'(F10.4,x)') p(Tiefe1(MetZahl))/1.d5		
		end if
	
		!Advance in time
		Zeit = Zeit+dt				
		
		!For genetical algorithm
		if (Programmtyp == 'Evolution') then			
			Zeiten1(Lang) = Zeit/1.d6			
			do i=0,k
				Temperaturen1(i,Lang) = T(i)
			end do
		end if		
	end do !End of main loop

	if (Programmtyp == 'Evolution') then
		allocate(Zeiten(Lang))
		allocate(Temperaturen(0:k,Lang))
		do i=1,Lang
			Zeiten(i) = Zeiten1(i)
			do j=0,k
				Temperaturen(j,i) = Temperaturen1(j,i)
			end do
		end do
	end if

	Radius_aus = R(k)

	Lauf = Lauf +1

	!More output
	if (Programmtyp == 'Durchlauf') then
		!various asteroid properties at the end of thermal evolution
		
		write(*,*) "time[Ma], central poro, central temp[K], timestep size[a] "
		open(1, file = 'Ausgabe/Asteroid.dat', status = 'replace')		
		write(1,'(A81)') "#This file produces general information of the setting for the calculated model."
		write(1,'(A84)') "#Properties of each spacial step in the asteroid after thermal evolution has ended."
		write(1,'(A96)') "#Radial position[km], density[g/cm³], cumulative mass[kg], pressure[bar]"&
				  &", max.temperature[K]"
		do i=0,k
			write(1,'(2x,5(G17.10,3x))') r(i)/1000.d0, rho_p(i), M(i), P(i)/1.d5 , T_maxi(i)	
		end do
		write(*,*) "",k_aktuell
		write(1,*) "#Maximum central temperature[K]", T_maxi(0)
		write(*,*) "Maximum central temperature[K]", T_maxi(0)
		write(1,*) " "
		write(1,*) "#Depths and maximum temperatures for selected layers"
		write(1,*) "#Layer,       depth[km],  maximum temperature[K]"
		do i=1,MetZahl		
			write(1,'(A7,x,I1,2x,F12.5,2x,F12.5)') "#Layer",i,(R(k)-R(Tiefe1(i)-1)-(R(Tiefe1(i))-R(Tiefe1(i)-1))*PosFak(i))/1.d3,T_max1(i)
			write(*,'(A7,x,I1,2x,F12.5,2x,F12.5)') "Layer",i,(R(k)-R(Tiefe1(i)-1)-(R(Tiefe1(i))-R(Tiefe1(i)-1))*PosFak(i))/1.d3,T_max1(i)
		end do
		
		write(1,*) " "
		write(1,*) "#Time at model end after CAI formation[Ma]", Zeit/1.d6	
		write(*,*) "T_max = ", T_maxi(0)
		write(*,*) "Asteroid radius[km]", r(k)/1.d3
		write(1,*) "#Asteroid radius[km]                      ", r(k)/1.d3
		write(1,*) " "
		write(1,*) "#Model parameters"
		write(1,*) "#Formation time[Ma]                       ", Bildungszeit/1.d6
		write(1,*) "#Initial Radius[km]                       ", Radius/1.d3
		write(1,*) "#Fe-60/Fe-56 ratio at CAI formation       ", f_Fe60
		write(1,*) "#Initial porosity                         ", phi_0
		write(1,*) "#Surface temperature[K] no disk           ", T_0
		write(1,*) "#Surface temperature[K] in disk           ", T_0
		write(1,*) "#Heat conductivity[W/mK]                  ", Wlvf
		write(*,*) "Time", Zeit/1.d6, " Mio a"
		
		write(*,*) " "
		write(*,*) "Maximum central temperature[K]",T_maxi(0)
		write(*,*) "Radius",Radius/1.d3
		write(*,*) "Number of timesteps calculated",Lang
		
		!output of radial position dependent maximum layer temperature
		open (2, file = 'Ausgabe/maxtemp.dat', status='replace')
		write(2,*) "#Here are shown the maximum temperatures for each layer"
		write(2,*) "#Radial position[km],       maximum temperature[K],   porosity"
		do i=0,k
			write(2,*) R(i)/1.d3,T_maxi(i),D(i)
		end do
		close(2)
		close(1)
		
		write(*,*) " "
		write(*,*) "Programme executed succesfully"
	end if
	
	deallocate(D_schliessen)
	deallocate(MaskeT)
	
	contains
	subroutine Fixpunktiteration
		implicit none
		!Fixed point iteration for single time step
		do while ( maxval(abs(delT)/Tp,MaskeT) > 5.d-8 .or. maxval(abs(delD/Dp),MaskeT) > 5.d-8 )
			if (Wachstumsstop .eqv. .true.) exit 	!If growth too fast, step has to be repeted with smaller time step. 
																						!Then no iteration necessary.
			Tpv=Tp;	Dv=Dp

			P = P_func(Dp,M,rho_p,R,P_G,Tp,k_aktuell)		!Pressure calculation				
			if(Helle .eqv. .true.) then										!Sintering: Choosing between Helle and Yomogida sintering
				Dp = Sintern(Tp,P,P_G,D,Dp,dt,k_aktuell,Kornradius)
			else
				Dp = SinternYom(D,Dp,Tp,P,dt,k_aktuell)	
			end if	
			if (Gemisch .eqv. .true.) then			!two component mixture or one component material?
				do i=0,k
					if (matrixdominiert .eqv. .true.)   D_eff(i) = Dp(i) / ( 1.d0-(1.d0-Dp(i))*(1.d0-f_ma) ) 
					if (chondrendominiert .eqv. .true.) D_eff(i) = Dp(i) !/ (1.d0-f_ma)
				end do			
			else
				D_eff = Dp
			end if
			
			!Solving heat conductivity equation for this timestep
			Tp = Diskretisierung(rho_p,T,Tp,D_eff,P,M,Zeit,dt,Q,Cp_Mat,R,j_alt,k_aktuell)	
	
			delT = Tp-Tpv; delD = Dp-Dv	

			iteration = iteration + 1		!If iteration takes too many tries, stop and repeat with smaller time step
			if (iteration > it_zahl) then				
				it_signal = .true.
				exit
			end if						
		end do
		!Iteration End
	end subroutine Fixpunktiteration
end subroutine Ast
