module Naturkonstanten
	use Modelleinstellungen
	implicit none	
	save

	!nature constants
	real(kind=8),parameter :: spa = 3600.d0*24.d0*365.25d0 	!seconds per year
	real(kind=8) :: R_G = 1.98649d-3 			!Gas constant in kcal/(mol*K)
	real(kind=8) :: R_gSI = 8.3144621d0		!Gas constant in SI
	real(kind=8) :: u_At = 1.660539d-27 	!atomic Mass unit u (C-12) in kg/mol
	real(kind=8) :: e_El =1.602176d-19 		!elemental charge
	real(kind=8) :: Gr = 6.673d-11 				!Gravitation constant 
	real(kind=8),parameter :: pi = 3.141592653589d0 		!pi
	real(kind=8) :: sigma_SB= 5.67d-8 		!Stefan-Boltzmann-constant
	real(kind=8) :: k_B = 1.3806488d-23		!Boltzmann constant
	
	!precalculated fractions
	real(kind=8) :: vpid = 4.d0*pi/3.d0  	! 4pi/3
	real(kind=8) :: drittel = 1.d0/3.d0  	! 1/3
	real(kind=8) :: zdrittel = 2.d0/3.d0 	! 2/3
	
	!conditions
	character(20) :: Programmtyp 		!decides if single asteroid evolution or optimisation is run
	
	!everything below here is set from files if Einlesen .eqv. .true.
	!heating isotopes constants
	real(kind=8) :: T_Al26 = 0.717d6 				!Aluminium26-halflive in years
	real(kind=8) :: T_U238 = 4.471917294d9 	!Uran238-halflive in years
	real(kind=8) :: T_U235 = 7.138488d8 		!Uran235-halflive in years
	real(kind=8) :: T_Th232 = 13.89072506d9 !Thorium232-halflive in years
	real(kind=8) :: T_K40 = 1.264867118d9 	!Kalium40-halflive in years
	real(kind=8) :: T_Fe60 = 2.62d6 		!Iron60-halflive in years
	real(kind=8) :: u_Al26 = 26.d0 			!Atomic mass in u
	real(kind=8) :: u_U238 = 238.d0 		!Atomic mass in u
	real(kind=8) :: u_U235 = 235.d0 		!Atomic mass in u
	real(kind=8) :: u_Th232 = 232.d0 		!Atomic mass in u
	real(kind=8) :: u_K40 = 40.d0 			!Atomic mass in u
	real(kind=8) :: u_Fe60 = 60.d0 			!Atomic mass in u
	real(kind=8) :: E_Al26 = 3.188d6 		!Decay energy in eV
	real(kind=8) :: E_Fe60 = 2.712d6 		!Decay energy in eV
	real(kind=8) :: E_K40 = 0.508d6 		!Decay energy in eV
	real(kind=8) :: E_Th232 = 40.4d6 		!Decay energy in eV
	real(kind=8) :: E_U235 = 44.4d6 		!Decay energy in eV
	real(kind=8) :: E_U238 = 47.5d6 		!Decay energy in eV
	real(kind=8) :: f_Al26 = 5.1d-5 		!isotope fractions
	real(kind=8) :: f_U238 = 0.76d0
	real(kind=8) :: f_U235 = 0.24d0
	real(kind=8) :: f_Th232 = 1.d0
	real(kind=8) :: f_K40 = 1.5d-3
	real(kind=8) :: X_Al = 9.1d-3				!Mass fractions of isotope elements
	real(kind=8) :: X_Fe = 0.293d0
	real(kind=8) :: X_K = 7.07d-4
	real(kind=8) :: X_Th = 4.91d-8
	real(kind=8) :: X_U = 2.72d-8
	
	!melting data
	real(kind=8) :: Sol_Fe = 1262.d0 		!Solidus temperature of iron(sulfide)
	real(kind=8) :: Liq_Fe = 1689.d0 		!Liquidus temperature of iron(sulfid)
	real(kind=8) :: Sol_Sil = 1440.d0 	!Solidus temperature Silicates
	real(kind=8) :: Liq_Sil = 1736.d0 	!Liquidus temperature Silicates
	real(kind=8) :: Lw_Fe = 2.7d5 			!Iron(sulfide)'s latent heat (W/kg)
	real(kind=8) :: Lw_Sil = 4.d5 			!Silicate's latent heat (W/kg)
	real(kind=8) :: Teil_Fe	= 0.25d0		!Fraction of Fe,Ni-FeS-phase in bulk material
	real(kind=8) :: Teil_Sil = 0.75d0		!Fraction of Silicates in buld material (Sum must be one)
	
	!other stuff
	integer :: cp_Zahl = 1500						!Number of data points of heat capacity in table Cp_H.dat
	real(kind=8) :: Z_Scheibe = 10.d6 	!disk lifetime respective to CAI formation
	real(kind=8) :: Aussendruck = 10.d0 !atmospheric pressure at surface
	real(kind=8) :: cp_0 = 800d0 				!initial heat capacity value for fit of Yomogida/Matsui	
	real(kind=8) :: rho_0 = 3.78d3			!density of compact material [kg/cm³]
	
	!material constants for sintering according to Rao/Kakar/Chaklader
	real(kind=8) :: Korn_H = 0.3d-3 		!grain radius [m]
	real(kind=8) :: A_S_c = 3.5d-11 		!front prefactor A in formula for olivine diffusion
	real(kind=8) :: B_S_c = 355.d3			!activation energy [kJ/mol] 	for olivine diffustion
	real(kind=8) :: n_sigma_S_c = 1.5d0 !tension exponent in formula  for olivine diffusion
	integer :: n_R_S_c = 3 							!grain rad. exp. in formula   for olivine diffusion
	real(kind=8) :: A_S_d = 1.5d3 			!front prefactor A in formula for olivine dislocation creep
	real(kind=8) :: B_S_d = 370.d3 			!activation energy [kJ/mol] 	for olivine dislocation creep
	real(kind=8) :: n_sigma_S_d = 3.d0 	!tension exponent in formula  for olivine dislocation creep
	integer :: n_R_S_d = 0 							!grain rad. exp. in formula 	for olivine dislocation creep
	real(kind=8) :: D0_Y = 0.62d0 			!Filling factor of closest packing for Rao/Kakar/Chalkader sintering

	!material constants for sintering according to Helle
	real(kind=8) :: D0_H = 0.56d0 		!Filling factor of closest packing for Helle sintering	
	real(kind=8) :: P_C = 1.d1 				!gas pressure in pores when pores close in Pascal
	real(kind=8) :: T_m = 2140.d0 		!melting temperature
	real(kind=8) :: b = 6.d-10 				!Burgers vector
	real(kind=8) :: A = 0.45d0				!Dorn constant
	real(kind=8) :: n_Sinter = 3.d0
	real(kind=8) :: Diff_v0 = 0.1d0		!Volumene diffusion constant
	real(kind=8) :: Q_v = 522.d3 
	real(kind=8) :: mue_0	= 8.13d4 		!Shearmodulus in Pascal
	real(kind=8) :: dmudt = -0.35d0 	!T_m/mue_0*dmue/dt		
	real(kind=8) :: O_Spann = 1.d0 		!surface tension
	real(kind=8) :: D_c = 0.9d0 			!filling density at pors closing
	real(kind=8) :: deltaD_0b = 1d-10 	!Boundary diffusion for Olivin in m^3/s
	real(kind=8) :: Q_b = 350d3 			!boundary diffusion for Olivin in J/mol
	real(kind=8) :: mu_g = 1.d0 			!mean molecular weight of inclosed gas	
	real(kind=8) :: Omega = 4.92d-29 	!Atomic volume

	!material constants needed for sintering in two component medium
	real(kind=8) :: Korn_M = 0.5d0*1.d-7	!grain radius Matrix material
	real(kind=8) :: Korn_C = 0.5d0*0.3d-3	!grain radius Chondren
	real(kind=8) :: D_cp = 0.64d0 		!random close packing of spheres
	real(kind=8) :: rho_C = 3.78d3		!Chondrule density 
	real(kind=8) :: rho_M = 3.78d3 		!Matrix density	
	
	character(10),dimension(:),allocatable :: Parametername
	character(12),dimension(:),allocatable :: Meteoritenname
	character( 7),dimension(:),allocatable :: SchliessTempName
	
	integer :: MetZahl = 9 		!Number of Meteorites used for fitting in Evolution_H.f90	
	integer :: SchliessTempzahl= 6!Number of closure temperatures used for fiting in Evolution_H.f90

	contains
	!This subroutine sets the material dependent variables initialised before to the values appropriate 
	!for the given material class
	subroutine Wertesetzen	
		implicit none	
		
		!Naming parameters. ParZahl strings have to be provided.
		!This is hardcoded, because it needs too sophisticated code editiong for change.
		allocate(Parametername(ParZahl))
		Parametername(1) = "Form. time"
		Parametername(2) = "    Radius"
		Parametername(3) = "     Fe-60"
		Parametername(4) = "  Porosity"
		Parametername(5) = "       T_0"
		Parametername(6) = "    K_bulk"
		Parametername(7) = "    growth"
		Parametername(8) = "       T_S"

		!Naming Meteorites. MetZahl strings have to be provided
		!Also set by file if Einlesen == .true.
		allocate(Meteoritenname(MetZahl))
		Meteoritenname(1) = "    Estacado"
		Meteoritenname(2) = "     Guarena"
		Meteoritenname(3) = "    Kernouve"
		Meteoritenname(4) = "   Mt.Browne"
		Meteoritenname(5) = "  Richardton"
		Meteoritenname(6) = "     Allegan"
		Meteoritenname(7) = "  Nadiabondi"
		Meteoritenname(8) = " Forest Vale"
		Meteoritenname(9) = "S.Marguerite"			
		
		!"Hf-W"	,"U-Pb-Pb","Ar-Ar","PuFT",	"Pb-Pb", "Al-Mg"
		!Also set by file if Einlesen == .true.
		allocate(SchliessTempName(SchliessTempZahl))	
		SchliessTempName(1) = "Hf-W   "
		SchliessTempName(2) = "U-Pb-Pb"
		SchliessTempName(3) = "Ar-Ar  "
		SchliessTempName(4) = "PuFT   "
		SchliessTempName(5) = "Pb-Pb  "
		SchliessTempName(6) = "Al-Mg  "		
	end subroutine Wertesetzen
end module Naturkonstanten
