subroutine Dateieingabe
	implicit none	
	character(30) :: Eingabe,data_file,user_data_file,cooling_age_file
	integer :: Lesestatus
	
	open(19,file="Subroutinen/files_used.dat",access="sequential",action="read",iostat=Lesestatus)
	write(*,*) "Read data from file: Subroutinen/files_used.dat"
	
	do while(.true.)
	  read(19,'(A30)',iostat=Lesestatus) Eingabe
	  if(Lesestatus/=0) cycle
	  if(trim(Eingabe) == "*******EndOfFile") exit
	  
	  if(Eingabe == "**data_file")        read(19,'(A30)') data_file	
	  if(Eingabe == "**user_data_file")   read(19,'(A30)') user_data_file
	  if(Eingabe == "**cooling_age_file") read(19,'(A30)') cooling_age_file
	end do
	close(19)
	
	!File for all stuff
	write(*,*) "Read data from file: Subroutinen/Daten.dat"
	!open(19,file="Subroutinen/Daten.dat",access="sequential",action="read")
	open(19,file=data_file,access="sequential",action="read")
  call DatEin	
	close(19)
	
	!Only often used parameters. Everything stated here overwrites all older values.
	write(*,*) "Read data from file: Daten.dat"
	open(19,file=user_data_file,access="sequential",action="read")
	call DatEin
	close(19)		

  !Input data for optimisation such as cooling ages and temperatures  
	if(Programmtyp == 'Evolution') then
	  write(*,*) "Read data from file: Subroutinen/Alter.dat"
		open(19,file=cooling_age_file,access="sequential",action="read")
		call MetEin
		close(19)		
	end if
	
	!Some unit conversions
	Radius_Anfang = Radius_Anfang*1.d3
	TieH=TieH*1.d3	
end subroutine Dateieingabe

!---------------------------------------------------------------------------------------------------------------------------------

subroutine DatEin
  implicit none
  character(16) :: Eingabe
  integer :: Lesestatus
  do while(.true.)	
	  !Get variable name
	  read(19,'(A16)',advance="no",iostat=Lesestatus) Eingabe
	  !write(*,*) Lesestatus, Eingabe
	  !End of file?
	  if(Lesestatus /= 0) cycle
	  if(Eingabe == "*******EndOfFile") exit
	
	  !Which variable is it?
	  select case (Eingabe)	    
		  case("Para_Ausgabe    ")		
		    read(19,*) Para_Ausgabe
		    if(Para_Ausgabe .eqv. .true.) then
		      write(*,*) "Para_Ausgabe",Para_Ausgabe
		    end if
		  case("Radius          ")
			  read(19,*) Radius
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Radius", Radius
			  end if
		  case("Bildungszeit    ")
			  read(19,*) Bildungszeit
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Bildungszeit",Bildungszeit
			  end if
		  case("f_Fe60          ")
			  read(19,*) f_Fe60
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "f_Fe60",f_Fe60
			  end if
		  case("phi_0           ")	
			  read(19,*) phi_0
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "phi_0",phi_0
			  end if
		  case("T_0             ")
			  read(19,*) T_0
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_0",T_0
			  end if
		  case("T_S             ")
			  read(19,*) T_S
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_S",T_S
			  end if
		  case("Wlvf            ")
			  read(19,*) Wlvf
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Wlvf",Wlvf
			  end if
		  case("Radius_Anfang   ")
			  read(19,*) Radius_Anfang
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Radius_Anfang",Radius_Anfang
			  end if
		  case("Akkretionsdauer ")
			  read(19,*) Akkretionsdauer
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Akkretionsdauer",Akkretionsdauer
			  end if
		  case("cp_genau        ")
			  read(19,*) cp_genau
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "cp_genau", cp_genau
			  end if
		  case("Helle           ")
			  read(19,*) Helle
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Helle",Helle
			  end if
		  case("Gemisch         ")
			  read(19,*) Gemisch
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Gemisch",Gemisch
			  end if
		  case("k               ")
			  read(19,*) k
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "k",k
			  end if
		  case("Dauer           ")
			  read(19,*) Dauer
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Dauer",Dauer
			  end if
		  case("TieH            ")		
			  read(19,*) (TieH(i), i=1,9)		
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "TieH",TieH
			  end if
		  case("T_Al26          ")		
			  read(19,*) T_Al26	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_Al26",T_Al26
			  end if
		  case("T_U238          ")		
			  read(19,*) T_U238	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_U238",T_U238
			  end if
		  case("T_U235          ")		
			  read(19,*) T_U235	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_U235",T_U235
			  end if
		  case("T_Th232         ")		
			  read(19,*) T_Th232	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_Th232",T_Th232
			  end if
		  case("T_K40           ")		
			  read(19,*) T_K40	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_K40",T_K40
			  end if
		  case("T_Fe60          ")		
			  read(19,*) T_Fe60	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_Fe60",T_Fe60
			  end if
		  case("u_Al26          ")		
			  read(19,*) u_Al26	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "u_Al26",u_Al26
			  end if
		  case("u_U238          ")		
			  read(19,*) u_U238	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "u_U238",u_U238
			  end if
		  case("u_U235          ")		
			  read(19,*) u_U235	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "u_U235",u_U235
			  end if
		  case("u_Th232         ")		
			  read(19,*) u_Th232	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "u_Th232",u_Th232
			  end if
		  case("u_K40           ")		
			  read(19,*) u_K40	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "u_K40",u_K40
			  end if
		  case("u_Fe60          ")		
			  read(19,*) u_Fe60	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "u_Fe60",u_Fe60
			  end if
		  case("E_Al26          ")		
			  read(19,*) E_Al26	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "E_Al26",E_Al26
			  end if
		  case("E_Fe60          ")		
			  read(19,*) E_Fe60	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "E_Fe60",E_Fe60
			  end if
		  case("E_K40           ")
			  read(19,*) E_K40	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "E_K40",E_K40
			  end if
		  case("E_Th232         ")	
			  read(19,*) E_Th232
			  if(Para_Ausgabe .eqv. .true.) then	
			    write(*,*) "E_Th232",E_Th232
			  end if
		  case("E_U235          ")		
			  read(19,*) E_U235	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "E_U235",E_U235
			  end if
		  case("E_U238          ")		
			  read(19,*) E_U238	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "E_U238",E_U238
			  end if
		  case("f_Al26          ")		
			  read(19,*) f_Al26
			  if(Para_Ausgabe .eqv. .true.) then	
			    write(*,*) "f_Al26",f_Al26
			  end if
		  case("f_U238          ")		
			  read(19,*) f_U238	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "f_U238",f_U238
			  end if
		  case("f_U235          ")		
			  read(19,*) f_U235	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "f_U235",f_U235
			  end if
		  case("f_Th232         ")		
			  read(19,*) f_Th232	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "f_Th232",f_Th232
			  end if
		  case("f_K40           ")		
			  read(19,*) f_K40	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "f_K40",f_K40
			  end if
		  case("X_Al            ")		
			  read(19,*) X_Al
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "X_Al",X_Al
			  end if
		  case("X_Fe            ")		
			  read(19,*) X_Fe	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "X_Fe",X_Fe		
			  end if	
		  case("X_K             ")		
			  read(19,*) X_K	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "X_K",X_K
			  end if
		  case("X_Th            ")		
			  read(19,*) X_Th	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "X_Th",X_Th
			  end if
		  case("X_U             ")		
			  read(19,*) X_U	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "X_U",	X_U	
			  end if
		  case("Sol_Fe          ")		
			  read(19,*) Sol_Fe	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Sol_Fe",Sol_Fe
			  end if
		  case("Liq_Fe          ")		
			  read(19,*) Liq_Fe	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Liq_Fe",Liq_Fe
			  end if
		  case("Sol_Sil         ")		
			  read(19,*) Sol_Sil	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Sol_Sil",Sol_Sil
			  end if
		  case("Liq_Sil         ")		
			  read(19,*) Liq_Sil	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Liq_Sil",Liq_Sil
			  end if
		  case("Lw_Fe           ")		
			  read(19,*) Lw_Fe 	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Lw_Fe",Lw_Fe
			  end if
		  case("Lw_Sil          ")		
			  read(19,*) Lw_Sil	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Lw_Sil",Lw_Sil
			  end if
		  case("Teil_Fe         ")		
			  read(19,*) Teil_Fe	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Teil_Fe",Teil_Fe
			  end if
		  case("Teil_Sil        ")		
			  read(19,*) 	Teil_Sil
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Teil_Sil",Teil_Sil
			  end if
		  case("cp_Zahl         ")		
			  read(19,*) cp_Zahl	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "cp_Zahl",cp_Zahl
			  end if
		  case("Z_Scheibe       ")		
			  read(19,*) Z_Scheibe	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Z_Scheibe",Z_Scheibe
			  end if
		  case("Aussendruck     ")		
			  read(19,*) Aussendruck
			  if(Para_Ausgabe .eqv. .true.) then	
			    write(*,*) "Aussendruck",Aussendruck
			  end if
		  case("cp_0            ")		
			  read(19,*) cp_0	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "cp_0",cp_0
			  end if
		  case("rho_0           ")		
			  read(19,*) rho_0	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "rho_0",rho_0
			  end if
		  case("Korn_H          ")		
			  read(19,*) Korn_H	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Korn_H",Korn_H
			  end if
		  case("A_S_c           ")		
		    read(19,*) A_S_c	
		    if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "A_S_c",A_S_c
			  end if
		  case("B_S_c           ")		
			  read(19,*) B_S_c	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "B_S_c",B_S_c
			  end if
		  case("n_sigma_S_c     ")		
			  read(19,*) n_sigma_S_c	
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "n_sigma_S_c",n_sigma_S_c
			  end if
		  case("n_R_S_c         ")		
			  read(19,*) n_R_S_c
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "n_R_S_c",n_R_S_c
			  end if
		  case("A_S_d           ")		
			  read(19,*) A_S_d
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "A_S_d",A_S_d
			  end if
		  case("B_S_d           ")		
			  read(19,*) B_S_d
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "B_S_d",B_S_d
			  end if
		  case("n_sigma_S_d     ")		
			  read(19,*) n_sigma_S_d
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "n_sigma_S_d",n_sigma_S_d
			  end if
		  case("n_R_S_d         ")		
			  read(19,*) n_R_S_d
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "n_R_S_d",n_R_S_d
			  end if
		  case("D0_Y            ")		
			  read(19,*) D0_Y
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "D0_Y",D0_Y
			  end if
		  case("D0_H            ")		
			  read(19,*) D0_H
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "D0_H",D0_H
			  end if
		  case("P_C             ")		
			  read(19,*) P_C
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "P_C",P_C
			  end if
		  case("T_m             ")		
			  read(19,*) T_m
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "T_m",T_m
			  end if
		  case("b               ")		
			  read(19,*) b
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "b",b
			  end if
		  case("A               ")		
			  read(19,*) A
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "A",A
			  end if
		  case("n_Sinter        ")		
			  read(19,*) n_Sinter
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "n_Sinter",n_Sinter
			  end if
		  case("Diff_v0         ")		
			  read(19,*) Diff_v0
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Diff_v0",Diff_v0
			  end if
		  case("Q_v             ")		
			  read(19,*) Q_v
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Q_v",Q_v
			  end if
		  case("mue_0           ")		
			  read(19,*) mue_0
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "mue_0",mue_0
			  end if
		  case("dmudt           ")		
			  read(19,*) dmudt
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "dmudt",dmudt
			  end if
		  case("O_Spann         ")		
			  read(19,*) O_Spann
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "O_Spann",O_Spann
			  end if
		  case("D_c             ")		
			  read(19,*) D_c
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "D_c",D_c
			  end if
		  case("deltaD_0b       ")		
			  read(19,*) deltaD_0b
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "deltaD_0b",deltaD_0b
			  end if
		  case("Q_b             ")		
			  read(19,*) Q_b
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Q_b",Q_b
			  end if
		  case("mu_g            ")	
			  read(19,*) mu_g
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "mu_g",mu_g
			  end if
		  case("Omega           ")		
			  read(19,*) Omega
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Omega",Omega
			  end if
		  case("Korn_M          ")		
			  read(19,*) Korn_M
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Korn_M",Korn_M
			  end if
		  case("Korn_C          ")		
			  read(19,*) Korn_C
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "Korn_C",Korn_C
			  end if
		  case("D_cp            ")		
			  read(19,*) D_cp
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "D_cp",D_cp
			  end if
		  case("rho_C           ")		
			  read(19,*) rho_C
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "rho_C",rho_C
			  end if
		  case("rho_M           ")		
			  read(19,*) rho_M
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "rho_M",rho_M
			  end if
		  case("MetZahl         ")		
			  read(19,*) MetZahl 
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "MetZahl",MetZahl
			  end if
		  case("SchliessTempZahl")		
			  read(19,*) SchliessTempZahl
			  if(Para_Ausgabe .eqv. .true.) then
			    write(*,*) "SchliessTempZahl",SchliessTempZahl	
			  end if
			case("f_ma            ")		
		    read(19,*) f_ma
		    if(Para_Ausgabe .eqv. .true.) then
		      write(*,*) "f_ma",f_ma
		    end if			 		
		  !case("  ")		
		  !  read(19,*) 
		    !if(Para_Ausgabe .eqv. .true.) then
		    !  write(*,*) "",
		    !end if
		  
	    case default
			  read(19,*)
			  !write(*,'(A15,x,A7)') Eingabe,"skipped"
	  end select
	end do
end subroutine DatEin

!---------------------------------------------------------------------------------------------------------------------------------

subroutine MetEin
  implicit none
  character(12) :: Eingabe
  character(7) :: Eingabe2
	integer :: Lesestatus,Lesestatus2,j
  AKZ = 0.d0
	AKZ_Fehler = 0.d0
	STemp = 0.d0
	STemp_Fehler = 0.d0
	Whileschleife: do while(.true.)
		read(19,'(A12)',advance="no",iostat=Lesestatus) Eingabe
		if(Lesestatus /= 0) cycle
		if(Eingabe == "***EndOfFile") exit
		
		if(Eingabe == "Meteoritenna") then
		  read(19,*)
		  do i=1,Metzahl
		    read(19,*) j,Meteoritenname(j)
		   ! write(*,*) j,Meteoritenname(j)
		  end do
		end if
		
		if(Eingabe == "SchliessTemp") then
		  read(19,*)
		  do i=1,SchliessTempZahl
		    read(19,*) j,SchliessTempName(j)
		   ! write(*,*) j,SchliessTempName(j)
		  end do
		end if		
		
		if(Eingabe == "ParBereich  ") then
		  read(19,*)		  
  	  read(19,*) Eingabe, BereichBZ(1),  BereichBZ(2)
  	        write(*,*) Eingabe, BereichBZ(1),  BereichBZ(2)
      read(19,*) Eingabe, BereichRad(1), BereichRad(2)
            write(*,*) Eingabe, BereichRad(1), BereichRad(2)
      read(19,*) Eingabe, BereichFe60(1),BereichFe60(2)
            write(*,*) Eingabe, BereichFe60(1),BereichFe60(2)
      read(19,*) Eingabe, BereichPor(1), BereichPor(2)
            write(*,*) Eingabe, BereichPor(1), BereichPor(2)
      read(19,*) Eingabe, BereichT_0(1), BereichT_0(2)
            write(*,*) Eingabe, BereichT_0(1), BereichT_0(2)
      read(19,*) Eingabe, BereichWlvf(1),BereichWlvf(2)
            write(*,*) Eingabe, BereichWlvf(1),BereichWlvf(2)
      read(19,*) Eingabe, BereichAkk(1), BereichAkk(2)
            write(*,*) Eingabe, BereichAkk(1), BereichAkk(2)
      read(19,*) Eingabe, BereichT_S(1), BereichT_S(2)     
            write(*,*) Eingabe, BereichT_S(1), BereichT_S(2)
		end if
			  
		!Read meteorite closure ages, their errors and closure temperatures
		Metschleife: do j=1,MetZahl
			if (Eingabe==adjustl(Meteoritenname(j))) then		
				!write(*,*) Eingabe
				read(19,*)		
				do while(.true.)
					read(19,'(A7)',advance="no",iostat=Lesestatus2) Eingabe2
					if(Lesestatus2 /= 0) cycle Metschleife 			
			
					do i=1,SchliessTempZahl  			
						if(Eingabe2==SchliessTempName(i)) then
							read(19,*) AKZ(j,i),AKZ_Fehler(j,i), STemp(j,i)	
							!write(*,*) Eingabe2,AKZ(j,i)/1.d6,AKZ_Fehler(j,i)/1.d6, STemp(j,i)						
						end if
					end do	
					
					if(Eingabe2=="Tmin   ")	then
					  read(19,*) Tmin(j),Tmin_Fehler(j)
					  !write(*,*) "Tmin",j,Tmin(j),Tmin_Fehler(j)
					end if
					if(Eingabe2=="Tmax   ") then
					  read(19,*) Tmax(j),Tmax_Fehler(j)
					  !write(*,*) "Tmax",j,Tmax(j),Tmax_Fehler(j)	
					end if	
				end do
				
			end if
		end do Metschleife
		
		!Read closure temperature errors
		if(Eingabe == "CoolAgeError") then
		  !write(*,*) Eingabe
			read(19,*)			
			do while(.true.)
				read(19,'(A7)',advance="no",iostat=Lesestatus2) Eingabe2
				if(Lesestatus2 /= 0) cycle Whileschleife			
		
				do i=1,SchliessTempZahl  			
					if(Eingabe2==SchliessTempName(i)) then
						read(19,*) STemp_Fehler(i)	
						!write(*,*) Eingabe2, STemp_Fehler(i)					
					end if
				end do				
			end do
		end if
		
		if(Eingabe == "CAI_Alter   ") then
		  read(19,*) CAI_Alter,CAI_Fehler
		  !write(*,*) "CAI_Alter",CAI_Alter,CAI_Fehler
		end if
	end do Whileschleife
	
	!Mark data matrix entries which are not used  
	Maske = .true.
	do i=1,MetZahl
		do j= 1,SchliessTempZahl
			if (AKZ(i,j) == 0.d0) Maske(i,j) = .false.
		end do
	end do
end subroutine MetEin
