function compare(Lang,xmin,Radien,Temperaturen,Zeiten) 
	use Parameter 
	use Naturkonstanten
	use Modelleinstellungen
	use Ubergabe
	use omp_lib
	implicit none
	integer, intent(in) :: Lang	
	real(kind=8), dimension(MetZahl),intent(inout) :: xmin
	real(kind=8), dimension(:),intent(in), allocatable :: Radien,Zeiten
	real(kind=8), dimension(:,:),intent(in), allocatable :: Temperaturen 
	integer, dimension(MetZahl) :: xmin_k
	real(kind=4),dimension(MetZahl) :: compare
	real(kind=8),dimension(MetZahl,Schliesstempzahl) :: Z_dp,T_dp,Z_Fehler
	real(kind=8),dimension(SchliessTempZahl) :: T_Fehler
	real(kind=8) :: Steigung
	integer :: i,j,jott,jj
	logical,dimension(MetZahl,Schliesstempzahl,0:k) :: Z_ausgeschrieben,T_ausgeschrieben
	real(kind=8),dimension(MetZahl,SchliessTempzahl,0:k) :: Z_Modell,T_Modell !cooling ages
	logical,dimension(0:k) :: T_max_erreicht	
	real(kind=8) :: Zeit__max
	interface
		function q_Max(x,y,Ausgabe)			
			implicit none
			real(kind=8) :: q_Max
			real(kind=8), dimension(0:2), intent(in) :: x,y
			real(kind=8), intent(out) :: Ausgabe
		end function q_Max
		function quadratischeInterpolation(x,y,Eingabe)			
			real(kind=8), intent(in),dimension(0:2) :: x,y
			real(kind=8), intent(in):: Eingabe
			real(kind=8) :: quadratischeInterpolation
		end function quadratischeInterpolation		
	end interface
	real(kind=8),dimension(0:2) :: xwert,ywert
	real(kind=8),dimension(MetZahl) :: chi_Schichten
	real(kind=8),dimension(0:k) :: Tmax_Schichten,Zmax_Schichten
	real(kind=8),dimension(MetZahl,Schliesstempzahl) :: chi_lokal
	real(kind=8) :: Summe
	integer,parameter :: Verfeinerung = 100 !Only even numbers
	logical,dimension(0:Verfeinerung,MetZahl) :: T_max_erreichtA
	real(kind=8),dimension(Lang,0:Verfeinerung,MetZahl) :: Temp !Temperature in selected position between two layers
	real(kind=8),dimension(0:Verfeinerung,MetZahl) :: Tmaxx,Zmaxx
	real(kind=8),dimension(MetZahl) :: compare1
	real(kind=8),dimension(MetZahl,SchliessTempzahl,0:Verfeinerung) :: Z_ModellA,T_ModellA !cooling ages
  logical,dimension(MetZahl,Schliesstempzahl,0:Verfeinerung) :: Z_ausgeschriebenA,T_ausgeschriebenA
  
  allocate(Z_Vektor(1:Lang))
	allocate(T_Matrix(1:Lang,0:k))

	Tmaxx = 0.d0
	Tmax_Schichten = 0.d0
	Zmax_Schichten = 0.d0  

	T_max_erreicht = .false.
	chi_Tmin = 0.d0
	chi_Tmax = 0.d0   
	T_max = 0.d0  
	chi = 0.d0      

	T__max = 0.d0
	Zeit__max = 0.d0
	chi_Schichten = 0.d0

	Z_dp = CAI_Alter -AKZ
	T_dp = STemp
	Z_Fehler = sqrt(AKZ_Fehler**2 + CAI_Fehler**2)
	T_Fehler = STemp_Fehler	
			
	do i=1,Lang	
		Z_Vektor(i) = Zeiten(i)*1.d6
		do j=0,k
			T_Matrix(i,j) = Temperaturen(j,i)
		end do
	end do
	do i=0,k
		Schalen(i) = Radien(i)
	end do

	!T_Matrix(i,j) i time index, j spacial index
	Z_Modell = 0.d0
	T_Modell = 0.d0
	Z_ausgeschrieben = .false.
	T_ausgeschrieben = .false.

	!Determine best layer for each meteorite
	do i=1,Lang -1
		do j=0,k
			!Determine maximum temperatures
			if ( T_Matrix(i,j) > Tmax_Schichten(j) .and. (T_max_erreicht(j) .eqv. .true.) ) then
				T_Max_erreicht(j) = .false.
			else if( T_Matrix(i,j) > Tmax_Schichten(j) ) then
				Tmax_Schichten(j) = T_Matrix(i,j)
			else if ( T_Matrix(i,j) < Tmax_Schichten(j) .and. (T_max_erreicht(j) .eqv. .false.) &
				&.and. T_Matrix(i,j) > Parameter_ein(8) .and. i > 2) then
				T_max_erreicht(j) = .true. !see, if maximum temperature already achieved
				xwert = (/ 	Z_Vektor(i-2),		Z_Vektor(i-1),		Z_Vektor(i) 		/)
				ywert = (/ 	T_Matrix(i-2,j),	T_Matrix(i-1,j),	T_Matrix(i,j) 	/)
				Zmax_Schichten(j) = q_Max(xwert,ywert,Tmax_Schichten(j))		
			end if
		
			do jott=1,MetZahl			
				!Chi-determination
				!Determine the times Z_Modell, when the corresponding closure temperature T_dp is 
				!fallen below, and the temperatures T_Modell, that are there at the cooling ages 
				!for each layer
				do jj = 1,SchliessTempZahl
					if(Maske(jott,jj) .eqv. .false.) then
						T_Modell(jott,jj,j) = 0.d0
						Z_Modell(jott,jj,j) = 0.d0
						cycle
					end if
					!Determine temperature at given cooling time
					if ( Z_Vektor(i) >= Z_dp(jott,jj) .and. (T_ausgeschrieben(jott,jj,j) .eqv. .false.)) then					
						xwert = (/ Z_Vektor(i-2), Z_Vektor(i-1), Z_Vektor(i) /)
						ywert = (/ 	T_Matrix(i-2,j),	T_Matrix(i-1,j),	T_Matrix(i,j) 	/)
						T_Modell(jott,jj,j) = quadratischeInterpolation(xwert,ywert,Z_dp(jott,jj))			
						T_ausgeschrieben(jott,jj,j) = .true. 
					end if				
					!Determine time at given closure temperature
					if ((T_max_erreicht(j) .eqv. .true.) .and. T_Matrix(i,j) < T_dp(jott,jj) .and. &
							&(Z_ausgeschrieben(jott,jj,j) .eqv. .false.) .and. Tmax_Schichten(j) >= T_dp(jott,jj) ) then					
						xwert = (/ T_Matrix(i-2,j), T_Matrix(i-1,j), T_Matrix(i,j) /)
						ywert = (/ Z_Vektor(i-2), Z_Vektor(i-1), Z_Vektor(i) /)			
						if( xwert(1) /= xwert(2) .and. xwert(1) /= xwert(0)) then 
							Z_Modell(jott,jj,j) = quadratischeInterpolation(xwert,ywert,T_dp(jott,jj)) 
						else
							Z_Modell(jott,jj,j) = Z_Vektor(i)
						end if					
						Z_ausgeschrieben(jott,jj,j) = .true.
					end if					
				end do			
			end do
		end do	
	end do

	T__max = Tmax_Schichten(0)
	T_max_erreicht = .false.
		 
	!The Z_Modell and T_Modell for each layer are now known.
	!Now it is only necessary to calculate a chi for each layer and meteorite
	do j=0,k
		do jott = 1,MetZahl
			do jj = 1,Schliesstempzahl
				if(Maske(jott,jj) .eqv. .false.) then
					chi_lokal(jott,jj) = 0.d0
					cycle
				end if		

				if ( Tmax_Schichten(j) >= T_dp(jott,jj)) then				
					if (Zmax_Schichten(j) < Z_dp(jott,jj) ) then
						!Case 1: maximum tempertures already achieved at Data point (normal case)
						Steigung = (T_Modell(jott,jj,j)-T_dp(jott,jj))/ (Z_Modell(jott,jj,j)-Z_dp(jott,jj))
						chi_lokal(jott,jj) = (T_Modell(jott,jj,j)-T_dp(jott,jj))**2 / &
							&(T_Fehler(jj)**2 + Steigung**2 * Z_Fehler(jott,jj)**2)				
					else
						!Case 2: maximum temperatures not yet achieved at datapoint
						chi_lokal(jott,jj) = (Z_Modell(jott,jj,j) - Z_dp(jott,jj))**2 / Z_Fehler(jott,jj)**2							
					end if
				!If maximum temperature close below closure temperature (i.e. within errors)
				else if ( Tmax_Schichten(j) >= T_dp(jott,jj)-T_Fehler(jj) .and. Tmax_Schichten(j) < T_dp(jott,jj)) then
					if (Zmax_Schichten(j) < Z_dp(jott,jj) ) then
						!Case 1: maximum temperature already achieved at data point (normal case)
						Steigung = (T_Modell(jott,jj,j)-T_dp(jott,jj))/ (Zmax_Schichten(j)-Z_dp(jott,jj))
						chi_lokal(jott,jj) = (T_Modell(jott,jj,j)-T_dp(jott,jj))**2 / (T_Fehler(jj)**2 + &
							&Steigung**2 * Z_Fehler(jott,jj)**2)
					else	
						!Case 2: maximum temperature not yet achieved at datapoint					
						chi_lokal(jott,jj) = (((T_dp(jott,jj)-Tmax_Schichten(j))/T_Fehler(jj))**2*(Z_dp(jott,jj))**2 / Z_Fehler(jott,jj)**2) &
						&+ (T_Modell(jott,jj,j) - T_dp(jott,jj))**2 / T_Fehler(jj)**2	
					end if
				!If layer temperature at the end of thermal evolution is still higher than closure temperature
				else if ( T_Matrix(Lang,j) >= T_dp(jott,jj) ) then
					chi_lokal(jott,jj) = (T_Matrix(Lang,j) - T_dp(jott,jj))*5.d0
				else
					!case 3: If maximum temperatur smaller than closure temperature		
					chi_lokal(jott,jj) = (T_Modell(jott,jj,j) - T_dp(jott,jj))**2 / T_Fehler(jj)**2 + (Z_Modell(jott,jj,j)-Z_dp(jott,jj))**2 &
					&/ Z_Fehler(jott,jj)**2
				end if
			end do
			Summe = 0.d0
			do jj = 1,Schliesstempzahl
				Summe = Summe + chi_lokal(jott,jj)
			end do
			if( chi_Schichten(jott) == 0.d0 .or. (summe < chi_Schichten(jott) .and. summe /= 0.d0) ) then			
				chi_Schichten(jott) = Summe
				do jj = 1,Schliesstempzahl
					chi(jott,jj) = chi_lokal(jott,jj)
				end do
				xmin_k(jott) = j			
				xmin(jott) = Schalen(j)/Schalen(k)			  
			end if			
		end do
	end do
	
  !T_Matrix(i,j) i time index, j spacial index
	Z_Modell = 0.d0
	T_Modell = 0.d0
	Z_ausgeschriebenA = .false.
	T_ausgeschriebenA = .false.

	!Improvement of layerdephts by searching within best layer
	do i=1,Lang
		do j=0,Verfeinerung
			do jott=1,MetZahl			
					if (xmin_k(jott) /= 0.d0 .and. xmin_k(jott) /= k) then
						xwert = (/ 0.d0, 						            dble(Verfeinerung)/2.d0, 	dble(Verfeinerung) 			/)
						ywert = (/ T_Matrix(i,xmin_k(jott)-1),	T_Matrix(i,xmin_k(jott)),	T_Matrix(i,xmin_k(jott)+1)  /)
						Temp(i,j,jott) = quadratischeInterpolation(xwert,ywert,dble(j))	
					else if (xmin_k(jott) == 0.d0) then
						Temp(i,j,jott) = T_Matrix(i,0)
					else if (xmin_k(jott) == k) then
						Temp(i,j,jott) = T_Matrix(i,k)
					else
						write(*,*) "Warning in EvoRest.f90 line 208"
						stop
					end if				
			end do
		end do
	end do

	Tmaxx = 0.d0
	Zmaxx = 0.d0
	T_max_erreichtA = .false.
	do i=2,Lang -1
		do j=0,Verfeinerung		
			!Determine maximum temperatures
			do jott=1,MetZahl
				if ( Temp(i,j,jott) > Tmaxx(j,jott) .and. (T_max_erreichtA(j,jott) .eqv. .true.) ) then
					T_Max_erreichtA(j,jott) = .false.
				else if( Temp(i,j,jott) > Tmaxx(j,jott) ) then
					Tmaxx(j,jott) = Temp(i,j,jott)				
				else if ( Temp(i,j,jott) < Tmaxx(j,jott) .and. (T_max_erreichtA(j,jott) .eqv. .false.) .and. &
						&Temp(i,j,jott) > Parameter_ein(8) ) then
					T_max_erreichtA(j,jott) = .true. !See if maximum temperature already achieved. 
					xwert = (/ 	Z_Vektor(i-2),		Z_Vektor(i-1),		Z_Vektor(i) 		/)
					ywert = (/ 	Temp(i-2,j,jott),	Temp(i-1,j,jott),	Temp(i,j,jott) 	/)
					Zmaxx(j,jott) = q_Max(xwert,ywert,Tmaxx(j,jott))
					Tmaxx(j,jott) = Tmaxx(j,jott)
				end if	
				!Chi-determination
				!Determine the times Z_Modell, when the corresponding closure temperature T_dp is fallen 
				!below, and the temperatures T_Modell, that are there at the cooling ages for each layer
				do jj = 1,SchliessTempZahl
					if(Maske(jott,jj) .eqv. .false.) then
						T_ModellA(jott,jj,j) = 0.d0
						Z_ModellA(jott,jj,j) = 0.d0
						cycle
					end if
					!determine temperature for given cooling time
					if ( Z_Vektor(i) >= Z_dp(jott,jj) .and. (T_ausgeschriebenA(jott,jj,j) .eqv. .false.)) then
						xwert = (/ Z_Vektor(i-2), 	Z_Vektor(i-1), 	 Z_Vektor(i) /)
						ywert = (/ Temp(i-2,j,jott),Temp(i-1,j,jott),Temp(i,j,jott)	/)
						T_ModellA(jott,jj,j) = quadratischeInterpolation(xwert,ywert,Z_dp(jott,jj)) 
						T_ausgeschriebenA(jott,jj,j) = .true. 
					end if				
					!determine temperature for given closure temperature
					if ((T_max_erreichtA(j,jott) .eqv. .true.) .and. Temp(i,j,jott) < T_dp(jott,jj) .and. &
							&(Z_ausgeschriebenA(jott,jj,j) .eqv. .false.) .and. Tmaxx(j,jott) >= T_dp(jott,jj) ) then					
						xwert = (/ Temp(i-1,j,jott), Temp(i,j,jott), Temp(i+1,j,jott) /)
						ywert = (/ Z_Vektor(i-1), Z_Vektor(i), Z_Vektor(i+1) /)			
						if( xwert(1) /= xwert(2) .and. xwert(1) /= xwert(0)) then 
							Z_ModellA(jott,jj,j) = quadratischeInterpolation(xwert,ywert,T_dp(jott,jj))
						else
							Z_ModellA(jott,jj,j) = Z_Vektor(i)
						end if					
						Z_ausgeschriebenA(jott,jj,j) = .true.
					end if					
				end do			
			end do
		end do	
	end do  
	chi_Schichten = 0.d0

	!After refinement
	!The Z_Modell and T_Modell for each layer are now known.
	!Now one must only calculate a chi for each layer and meteorite
	do j=0,Verfeinerung
		do jott = 1,MetZahl
			do jj = 1,Schliesstempzahl
				if(Maske(jott,jj) .eqv. .false.) then
					chi_lokal(jott,jj) = 0.d0
					cycle
				end if		

				if ( Tmaxx(j,jott) >= T_dp(jott,jj)) then				
					if (Zmaxx(j,jott) < Z_dp(jott,jj) ) then
						!Case 1: maximum tempertures already achieved at Data point (normal case)
						Steigung = (T_ModellA(jott,jj,j)-T_dp(jott,jj))/ (Z_ModellA(jott,jj,j)-Z_dp(jott,jj))
						chi_lokal(jott,jj) = (T_ModellA(jott,jj,j)-T_dp(jott,jj))**2 / (T_Fehler(jj)**2 + &
							&Steigung**2 * Z_Fehler(jott,jj)**2)
					else
						!Case 2: maximum temperatures not yet achieved at datapoint
						chi_lokal(jott,jj) = (Z_ModellA(jott,jj,j) - Z_dp(jott,jj))**2 / Z_Fehler(jott,jj)**2								
					end if
				!If maximum temperature close below closure temperature (i.e. within errors)
				else if ( Tmaxx(j,jott) >= T_dp(jott,jj)-T_Fehler(jj) .and. Tmaxx(j,jott) < T_dp(jott,jj)) then
					if (Zmaxx(j,jott) < Z_dp(jott,jj) ) then
						!Case 1: maximum tempertures already achieved at Data point (normal case)
						Steigung = (T_ModellA(jott,jj,j)-T_dp(jott,jj))/ (Zmaxx(j,jott)-Z_dp(jott,jj))
						chi_lokal(jott,jj) = (T_ModellA(jott,jj,j)-T_dp(jott,jj))**2 / (T_Fehler(jj)**2 + &
							&Steigung**2 * Z_Fehler(jott,jj)**2)
					else
						!Case 2: maximum temperatures not yet achieved at datapoint						
						chi_lokal(jott,jj) = (((T_dp(jott,jj)-Tmaxx(j,jott))/T_Fehler(jj))**2*(Z_dp(jott,jj))**2 / Z_Fehler(jott,jj)**2) &
						&+ (T_ModellA(jott,jj,j) - T_dp(jott,jj))**2 / T_Fehler(jj)**2		
					end if				
				!If layer temperature at the end of thermal evolution is still higher than closure temperature
				else if ( Temp(Lang,j,jott) >= T_dp(jott,jj) ) then
					chi_lokal(jott,jj) = (Temp(Lang,j,jott) - T_dp(jott,jj))*5.d0
				else
					!case 3: If maximum temperatur smaller than closure temperature				
					chi_lokal(jott,jj) = (T_ModellA(jott,jj,j) - T_dp(jott,jj))**2 / T_Fehler(jj)**2 + (Z_dp(jott,jj)-Z_ModellA(jott,jj,j))**2 &
					&/ Z_Fehler(jott,jj)**2
				end if
			end do
			Summe = 0.d0
			do jj = 1,Schliesstempzahl
				Summe = Summe + chi_lokal(jott,jj)
			end do
			if( chi_Schichten(jott) == 0.d0 .or. (summe < chi_Schichten(jott) .and. summe /= 0.d0) ) then			
				chi_Schichten(jott) = Summe
				do jj = 1,Schliesstempzahl
					chi(jott,jj) = chi_lokal(jott,jj)
				end do
				if(j==0) then
					if(xmin_k(jott) > 0) then 
						xmin(jott) = Schalen(xmin_k(jott)-1)/Schalen(k)
					else
						xmin(jott) = 0.d0
					end if
				else if (j/=0 .and. j<Verfeinerung/2) then				
					if (xmin_k(jott) /= 0.d0 .and. xmin_k(jott) /= k) then 
						xmin(jott) = ( Schalen(xmin_k(jott)-1) + &
							&(Schalen(xmin_k(jott))-Schalen(xmin_k(jott)-1)) *j/ dble(Verfeinerung) )/Schalen(k)
					else if (xmin_k(jott) == 0.d0) then
						xmin(jott) = Schalen(0)
					else if (xmin_k(jott) == k) then
						xmin(jott) = Schalen(k)
					else
						write(*,*) "Warning EvoRest.f90 line 318"
					end if
				else if (j==Verfeinerung/2) then
					xmin(jott) = Schalen(xmin_k(jott))/Schalen(k)
				else if (j>Verfeinerung/2 .and. j/=Verfeinerung) then
					if (xmin_k(jott) /= 0.d0 .and. xmin_k(jott) /= k) then 
						xmin(jott) = ( Schalen(xmin_k(jott)) + &
							&(Schalen(xmin_k(jott)+1)-Schalen(xmin_k(jott))) *j/ dble(Verfeinerung) )/Schalen(k)
					else if (xmin_k(jott) == 0.d0) then
						xmin(jott) = Schalen(0)
					else if (xmin_k(jott) == k) then
						xmin(jott) = Schalen(k)
					else
						write(*,*) "Warning EvoRest.f90 line 318"
					end if
				else if (j==Verfeinerung) then	
				  if(xmin_k(jott) < k) then		
					  xmin(jott) = Schalen(xmin_k(jott)+1)/Schalen(k)	
					else
					  xmin(jott) = 1.d0
					end if						
				end if
				T_max(jott) = Tmaxx(j,jott)			  
			end if
		end do
	end do

	deallocate(Z_Vektor)
	deallocate(T_Matrix)

	!After loop
	do jott=1,MetZahl
		!Have the necessary minimum temperatures been achieved yet?
		!Adding an additional chi to the others if temperature not achieved
		chi_Tmin(jott) = 0.d0
		chi_Tmax(jott) = 0.d0 
		if ( T_max(jott) < Tmin(jott) .and. Tmin(jott) .ne. 0.d0) chi_Tmin(jott) =  ( Tmin(jott)-T_max(jott) )**2 / Tmin_Fehler(jott)**2
		if ( T_max(jott) > Tmax(jott) .and. Tmax(jott) .ne. 0.d0) chi_Tmax(jott) =  ( Tmax(jott)-T_max(jott) )**2 / Tmax_Fehler(jott)**2
	end do

	compare1 = 0.d0
	do jott = 1, MetZahl
		compare1(jott) = 0.d0
		do jj= 1,SchliessTempzahl
			Compare1(jott) = chi(jott,jj)+compare1(jott)
		end do
	end do 
	compare1 = compare1 + chi_Tmin+chi_Tmax 
	compare = real(compare1)
end function compare 

!----------------------------------------------------------------------------------------------------

function q_Max(x,y,Ausgabe)
	!This function interpolates the three Input points (x1,y1),(x2,y2),(x3,y3)
	!by a quadratic function and calculates the extremum.
	!At the extremum the function has output value Ausgabe
	!x1<x2<x3 has to be fulfilled
	implicit none
	real(kind=8) :: q_Max
	real(kind=8), dimension(0:2), intent(in) :: x,y
	real(kind=8), intent(out) :: Ausgabe
	real(kind=8) :: a,b,c,Nenner,Zaehler

	Nenner = (x(0)-x(1))*(x(0)-x(2))*(x(1)-x(2))

	!Denominator of a
	Zaehler = y(0)*(x(1)-x(2)) - y(1)*(x(0)-x(2)) + y(2)*(x(0)-x(1))
	a = Zaehler / Nenner

	!Denominator of b
	Zaehler = -(y(0)*(x(1)**2-x(2)**2) - y(1)*(x(0)**2-x(2)**2) + y(2)*(x(0)**2-x(1)**2))
	b = Zaehler / Nenner

	!Denominator of c
	Zaehler = y(0)*x(1)*x(2)*(x(1)-x(2)) - y(1)*x(0)*x(2)*(x(0)-x(2)) + y(2)*x(0)*x(1)*(x(0)-x(1))
	c = Zaehler / Nenner

	q_Max = -b/a *0.5d0

	Ausgabe = a*q_Max**2+b*q_Max+c
end function q_Max

!----------------------------------------------------------------------------------------------------

function quadratischeInterpolation(x,y,Eingangswert)
	!This function interpolates the input data paires x,y,z at the position Ausgabe and returns the 
	!function value of Eingangswert
	implicit none
	real(kind=8) :: quadratischeInterpolation
	real(kind=8),intent(in),dimension(0:2) :: x,y
	real(kind=8),intent(in) :: Eingangswert
	real(kind=8),dimension(0:2) :: l

	l(0) = (Eingangswert-x(1))*(Eingangswert-x(2)) / ((x(0)-x(1))*(x(0)-x(2)))
	l(1) = (Eingangswert-x(0))*(Eingangswert-x(2)) / ((x(1)-x(0))*(x(1)-x(2)))
	l(2) = (Eingangswert-x(0))*(Eingangswert-x(1)) / ((x(2)-x(0))*(x(2)-x(1)))

	quadratischeInterpolation = y(0)*l(0)+y(1)*l(1)+y(2)*l(2)
end function quadratischeInterpolation

!----------------------------------------------------------------------------------------------------
     
include 'Subroutinen/pikaia.f90'      
!      
!*****************************************************************************************************
!*****************************************************************************************************
!Asteroid
!*****************************************************************************************************
!*****************************************************************************************************   
include 'Subroutinen/Ast.f90' 
